/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ibmvm.acquire;

import com.ibm.tools.attach.VirtualMachine;
import com.ibm.tools.attach.VirtualMachineDescriptor;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.ibmvm.acquire.AgentLoader2;
import org.eclipse.mat.ibmvm.acquire.BaseProvider;
import org.eclipse.mat.ibmvm.acquire.DumpType;
import org.eclipse.mat.ibmvm.acquire.IBMDumpProvider;
import org.eclipse.mat.ibmvm.acquire.IBMHeapDumpProvider;
import org.eclipse.mat.ibmvm.acquire.IBMJavaDumpProvider;
import org.eclipse.mat.ibmvm.acquire.IBMSystemDumpProvider;
import org.eclipse.mat.ibmvm.acquire.IBMVmInfo;
import org.eclipse.mat.ibmvm.acquire.Messages;
import org.eclipse.mat.query.annotations.Help;
import org.eclipse.mat.query.annotations.Name;
import org.eclipse.mat.snapshot.acquire.IHeapDumpProvider;
import org.eclipse.mat.snapshot.acquire.VmInfo;
import org.eclipse.mat.util.IProgressListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
@Name(value="IBM Dump (using attach API)")
@Help(value="help for IBM Dump (using attach API)")
public class IBMDumpProvider
extends BaseProvider {
    private static File agentJar;

    IBMDumpProvider() {
    }

    String dumpName() {
        return new File("ibmdump.dmp").getAbsolutePath();
    }

    int files() {
        return 1;
    }

    File jextract(File preferredDump, boolean compress, List<File> dumps, File udir, File javahome, IProgressListener listener) throws IOException, InterruptedException, SnapshotException {
        return dumps.get(0);
    }

    long averageFileSize(Collection<File> files) {
        long l = 0L;
        int i = 0;
        for (File f : files) {
            if (!f.isFile()) continue;
            l += f.length();
            ++i;
        }
        return l / (long)i;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public File acquireDump(VmInfo info, File preferredLocation, IProgressListener listener) throws SnapshotException {
        IBMVmInfo vminfo = (IBMVmInfo)info;
        IBMDumpProvider helper = this.getDumpProvider(vminfo);
        if (helper != this) {
            return helper.acquireDump(info, preferredLocation, listener);
        }
        listener.beginTask(Messages.getString("IBMDumpProvider.GeneratingDump"), 1980);
        try {
            listener.subTask(MessageFormat.format(Messages.getString("IBMDumpProvider.AttachingToVM"), vminfo.getPidName()));
            VirtualMachine vm = VirtualMachine.attach((String)vminfo.getPidName());
            try {
                File udir;
                Properties props = vm.getSystemProperties();
                String javah = props.getProperty("java.home", System.getProperty("java.home"));
                File javahome = new File(javah);
                if (vminfo.dumpdir == null) {
                    String userdir = props.getProperty("user.dir", System.getProperty("user.dir"));
                    udir = new File(userdir);
                } else {
                    udir = vminfo.dumpdir;
                }
                File[] f1 = udir.listFiles();
                HashSet<File> previous = new HashSet<File>(Arrays.asList(f1));
                long avg = this.averageFileSize(previous);
                String jar = IBMDumpProvider.getAgentJar().getAbsolutePath();
                listener.subTask(Messages.getString("IBMDumpProvider.StartingAgent"));
                AgentLoader t = new AgentLoader(jar, vm, vminfo.agentCommand(), null);
                t.start();
                List newFiles = this.progress(udir, previous, this.files(), avg, (AgentLoader2)t, listener);
                if (listener.isCanceled()) {
                    t.interrupt();
                    return null;
                }
                if (t.failed()) {
                    t.throwFailed(listener);
                }
                listener.done();
                if (newFiles.isEmpty()) {
                    String msg = MessageFormat.format(Messages.getString("IBMDumpProvider.UnableToFindDump"), udir.getAbsoluteFile());
                    throw new FileNotFoundException(msg);
                }
                File file = this.jextract(preferredLocation, vminfo.compress, newFiles, udir, javahome, listener);
                return file;
            }
            catch (InterruptedException e) {
                listener.sendUserMessage(IProgressListener.Severity.WARNING, Messages.getString("IBMDumpProvider.Interrupted"), (Throwable)e);
                throw new SnapshotException(Messages.getString("IBMDumpProvider.Interrupted"), (Throwable)e);
            }
            finally {
                vm.detach();
            }
        }
        catch (IOException e) {
            listener.sendUserMessage(IProgressListener.Severity.WARNING, Messages.getString("IBMDumpProvider.UnableToGenerateDump"), (Throwable)e);
            throw new SnapshotException(Messages.getString("IBMDumpProvider.UnableToGenerateDump"), (Throwable)e);
        }
        catch (SnapshotException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            info.setHeapDumpEnabled(false);
            listener.sendUserMessage(IProgressListener.Severity.WARNING, Messages.getString("IBMDumpProvider.UnsuitableVM"), (Throwable)e);
            throw new SnapshotException(Messages.getString("IBMDumpProvider.UnsuitableVM"), (Throwable)e);
        }
    }

    /*
     * Unable to fully structure code
     */
    private List<File> progress(File udir, Collection<File> previous, int nfiles, long avg, AgentLoader2 loader, IProgressListener listener) throws InterruptedException {
        listener.subTask(Messages.getString("IBMDumpProvider.WaitingForDumpFiles"));
        newFiles = new ArrayList<File>();
        l = 0L;
        worked = 0;
        start = System.currentTimeMillis();
        i = 0;
        while ((l = this.fileLengths(udir, previous, newFiles, nfiles)) == 0L && i < 60 && (t = System.currentTimeMillis()) < start + 30000L) {
            Thread.sleep(500L);
            if (listener.isCanceled() || loader.failed()) {
                return null;
            }
            towork = (int)Math.min((t - start) / 500L, 60L);
            listener.worked(towork - worked);
            worked = towork;
            ++i;
        }
        listener.worked(60 - worked);
        worked = 60;
        l0 = l - 1L;
        iFile = 0;
        start = System.currentTimeMillis();
        i = 0;
        j = 0;
        ** GOTO lbl38
        {
            listener.subTask(MessageFormat.format(Messages.getString("IBMDumpProvider.WritingFile"), new Object[]{newFiles.get(iFile++)}));
            do {
                if (iFile < newFiles.size()) continue block1;
                if (l0 != l) {
                    j = 0;
                    towork = (int)(l * 1320L / avg);
                    listener.worked(towork - worked);
                    worked = towork;
                    l0 = l;
                }
                Thread.sleep(500L);
                if (listener.isCanceled() || loader.failed()) {
                    return null;
                }
                listener.worked(1);
                ++i;
lbl38:
                // 2 sources

            } while (((l = this.fileLengths(udir, previous, newFiles, nfiles)) != l0 || j++ < 10 || newFiles.size() > iFile) && i < 600 && (t = System.currentTimeMillis()) < start + 300000L);
        }
        it = newFiles.iterator();
        while (it.hasNext()) {
            f = (File)it.next();
            if (f.exists()) continue;
            it.remove();
        }
        return newFiles;
    }

    private static synchronized File getAgentJar() throws IOException {
        if (agentJar == null || !agentJar.canRead()) {
            agentJar = IBMDumpProvider.makeAgentJar();
        }
        return agentJar;
    }

    private static File makeAgentJar() throws IOException, FileNotFoundException {
        String jarname = "org.eclipse.mat.ibmdumps";
        String[] agents = new String[]{"org.eclipse.mat.ibmvm.agent.DumpAgent"};
        Class[] cls = new Class[]{};
        return IBMDumpProvider.makeJar((String)jarname, (String)"Agent-class: ", (String[])agents, (Class[])cls);
    }

    List<File> files(File udir, Collection<File> previousFiles, List<File> newFiles) {
        File[] f2 = udir.listFiles((FileFilter)new NewFileFilter(previousFiles, null));
        List<File> new2 = Arrays.asList(f2);
        Collections.sort(new2, new FileComparator(null));
        previousFiles.addAll(new2);
        newFiles.addAll(new2);
        return newFiles;
    }

    long fileLengths(File udir, Collection<File> previous, List<File> newFiles, int maxFiles) {
        List nw = this.files(udir, previous, newFiles);
        long l = 0L;
        int i = 0;
        for (File f : nw) {
            if (!f.exists()) continue;
            if (++i > maxFiles) break;
            l += f.length();
        }
        return l;
    }

    public List<IBMVmInfo> getAvailableVMs(IProgressListener listener) {
        try {
            return this.getAvailableVMs1(listener);
        }
        catch (LinkageError e) {
            return null;
        }
    }

    private List<IBMVmInfo> getAvailableVMs1(IProgressListener listener) {
        List list = VirtualMachine.list();
        listener.beginTask(Messages.getString("IBMDumpProvider.ListingIBMVMs"), list.size());
        ArrayList<IBMVmInfo> jvms = new ArrayList<IBMVmInfo>();
        for (VirtualMachineDescriptor vmd : list) {
            boolean usable = true;
            String dir = null;
            String displayName = vmd.displayName();
            if (vmd.id().equals(displayName) && this.listAttach) {
                try {
                    VirtualMachine vm = vmd.provider().attachVirtualMachine(vmd);
                    try {
                        Properties p = vm.getSystemProperties();
                        dir = p.getProperty("user.dir");
                        displayName = p.getProperty("java.class.path");
                        if (displayName == null || displayName.equals("")) {
                            displayName = dir;
                        }
                    }
                    finally {
                        vm.detach();
                    }
                }
                catch (IOException e) {
                    usable = false;
                }
                catch (Exception e) {
                    usable = false;
                }
            }
            try {
                VirtualMachine.class.getMethod("loadAgent", String.class, String.class);
            }
            catch (NoSuchMethodException e) {
                return null;
            }
            String desc = MessageFormat.format(Messages.getString("IBMDumpProvider.VMDescription"), vmd.provider().name(), vmd.provider().type(), displayName);
            IBMVmInfo ifo = new IBMVmInfo(vmd.id(), desc, usable, null, (IHeapDumpProvider)this);
            ifo.type = this.defaultType;
            ifo.compress = this.defaultCompress;
            if (dir != null) {
                ifo.dumpdir = new File(dir);
            }
            jvms.add(ifo);
            ifo.setHeapDumpEnabled(usable);
            listener.worked(1);
            if (!listener.isCanceled()) continue;
            this.listAttach = false;
            break;
        }
        listener.done();
        return jvms;
    }

    public static void main(String[] s) throws Exception {
        IBMDumpProvider prov = new IBMDumpProvider();
        if (s.length < 4 && s.length > 0) {
            prov.listAttach = Boolean.parseBoolean(s[0]);
        }
        StderrProgressListener ii = new StderrProgressListener(null);
        List vms = prov.getAvailableVMs1((IProgressListener)ii);
        for (VmInfo info : vms) {
            DumpType tp;
            IBMVmInfo vminfo = (IBMVmInfo)info;
            String vm = vminfo.getPidName();
            String dir = vminfo.dumpdir != null ? vminfo.dumpdir.getAbsolutePath() : "";
            String vm2 = String.valueOf(vm) + INFO_SEPARATOR + info.getProposedFileName() + INFO_SEPARATOR + dir + INFO_SEPARATOR + info.getDescription();
            if (s.length < 4) {
                System.out.println(vm2);
                continue;
            }
            if (!vm.equals(s[1])) continue;
            vminfo.type = tp = DumpType.valueOf(s[0]);
            vminfo.compress = Boolean.parseBoolean(s[2]);
            if (s.length > 4) {
                vminfo.dumpdir = new File(s[4]);
            }
            File f2 = info.getHeapDumpProvider().acquireDump(info, new File(s[3]), (IProgressListener)ii);
            System.out.println(f2.getAbsolutePath());
            return;
        }
        if (s.length > 1) {
            throw new IllegalArgumentException(MessageFormat.format(Messages.getString("IBMDumpProvider.NoVMFound"), s[1]));
        }
    }

    IBMDumpProvider getDumpProvider(IBMVmInfo info) {
        if (this.getClass() != IBMDumpProvider.class) {
            return this;
        }
        if (info.type == DumpType.SYSTEM) {
            return new IBMSystemDumpProvider();
        }
        if (info.type == DumpType.HEAP) {
            return new IBMHeapDumpProvider();
        }
        if (info.type == DumpType.JAVA) {
            return new IBMJavaDumpProvider();
        }
        return this;
    }

    File mergeFileNames(File preferredDump, File actual) {
        File ret;
        String fn1 = preferredDump.getName();
        String fn1a = fn1.replaceAll("\\d", "#");
        String fn2 = actual.getName();
        String fn2a = fn2.replaceAll("\\d", "#");
        int fi = fn1a.indexOf(fn2a = fn2a.substring(0, fn2a.lastIndexOf(35) + 1));
        if (fi >= 0) {
            String newfn = String.valueOf(fn1.substring(0, fi)) + fn2.substring(0, fn2a.length()) + fn1.substring(fi + fn2a.length());
            ret = new File(preferredDump.getParentFile(), newfn);
        } else {
            ret = preferredDump;
        }
        return ret;
    }
}

