/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.internal.browser;

import java.util.Collections;
import java.util.List;
import org.eclipse.mat.internal.snapshot.HeapObjectContextArgument;
import org.eclipse.mat.query.IContextObject;
import org.eclipse.mat.query.IContextObjectSet;
import org.eclipse.mat.query.IStructuredResult;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.registry.ArgumentDescriptor;
import org.eclipse.mat.query.registry.ArgumentSet;
import org.eclipse.mat.query.registry.QueryDescriptor;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.query.IHeapObjectArgument;
import org.eclipse.mat.ui.util.IPolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Policy
implements IPolicy {
    private final boolean singleRowSelection;
    private final boolean multiRowSelection;
    private final boolean multiObjectSelection;
    private Class<? extends IContextObject> type;
    private List<IContextObject> context;
    private String label;

    public Policy(List<IContextObject> menuContext, String selectionLabel) {
        this.singleRowSelection = menuContext.size() == 1;
        this.multiRowSelection = menuContext.size() > 1;
        this.multiObjectSelection = this.multiRowSelection || this.singleRowSelection && menuContext.get(0) instanceof IContextObjectSet;
        this.type = IContextObjectSet.class;
        for (IContextObject obj : menuContext) {
            if (IContextObjectSet.class.isAssignableFrom(obj.getClass())) continue;
            this.type = IContextObject.class;
            break;
        }
        this.context = menuContext;
        this.label = selectionLabel;
    }

    public Policy() {
        this(Collections.emptyList(), "");
    }

    @Override
    public boolean accept(QueryDescriptor query) {
        boolean heapObjectArgExists = false;
        boolean heapObjectArgIsMultiple = false;
        boolean contextObjectArgExists = false;
        boolean contextObjectArgIsMultiple = false;
        boolean tableArgExists = false;
        for (ArgumentDescriptor argument : query.getArguments()) {
            if (this.isHeapObject(argument)) {
                heapObjectArgExists = true;
                heapObjectArgIsMultiple = heapObjectArgIsMultiple || argument.isMultiple() || IHeapObjectArgument.class.isAssignableFrom(argument.getType());
                continue;
            }
            if (IContextObject.class.isAssignableFrom(argument.getType())) {
                contextObjectArgExists = true;
                boolean bl = contextObjectArgIsMultiple = contextObjectArgIsMultiple || argument.isMultiple();
                if (argument.getType().isAssignableFrom(this.type)) continue;
                return false;
            }
            if (!IStructuredResult.class.isAssignableFrom(argument.getType())) continue;
            tableArgExists = true;
        }
        if (!heapObjectArgExists && !contextObjectArgExists && (this.singleRowSelection || this.multiRowSelection)) {
            return false;
        }
        if (heapObjectArgExists && !heapObjectArgIsMultiple && this.multiObjectSelection) {
            return false;
        }
        if (contextObjectArgExists && (this.multiRowSelection ? !contextObjectArgIsMultiple : !this.singleRowSelection)) {
            return false;
        }
        return !tableArgExists;
    }

    private boolean isHeapObject(ArgumentDescriptor argument) {
        Class argType = argument.getType();
        if (argType.isAssignableFrom(Integer.TYPE) && argument.getAdvice() == Argument.Advice.HEAP_OBJECT) {
            return true;
        }
        if (argType.isAssignableFrom(IObject.class)) {
            return true;
        }
        return argType.isAssignableFrom(IHeapObjectArgument.class);
    }

    @Override
    public void fillInObjectArguments(ISnapshot snapshot, QueryDescriptor query, ArgumentSet set) {
        if (!this.singleRowSelection && !this.multiRowSelection) {
            return;
        }
        Class<Integer> intClass = Integer.TYPE;
        boolean doneHeap = false;
        for (ArgumentDescriptor argument : query.getArguments()) {
            if (intClass.isAssignableFrom(argument.getType()) && argument.getAdvice() == Argument.Advice.HEAP_OBJECT || IObject.class.isAssignableFrom(argument.getType()) || IHeapObjectArgument.class.isAssignableFrom(argument.getType())) {
                if (doneHeap) continue;
                set.setArgumentValue(argument, (Object)new HeapObjectContextArgument(snapshot, this.context, this.label));
                doneHeap = true;
                continue;
            }
            if (IContextObjectSet.class.isAssignableFrom(argument.getType())) {
                if (argument.isMultiple()) {
                    set.setArgumentValue(argument, this.context);
                    continue;
                }
                set.setArgumentValue(argument, (Object)this.context.get(0));
                continue;
            }
            if (!IContextObject.class.isAssignableFrom(argument.getType())) continue;
            if (argument.isMultiple()) {
                set.setArgumentValue(argument, this.context);
                continue;
            }
            set.setArgumentValue(argument, (Object)this.context.get(0));
        }
    }
}

